/*
 * Decompiled with CFR 0.152.
 */
package b1module;

import b1module.B1Module;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class B1ClientWindow
extends JFrame {
    private static B1Module b1;
    private final int B1SerialBaudrate_Default = 9600;
    private final char B1RFIDCommandGetUIDAndType = '\u0001';
    private final char B1RFIDCommandHalt = (char)24;
    private final char B1RegisterCommand = '\u0001';
    private final char B1RegisterTagUID = (char)20;
    private final char B1RegisterDataBuffer = (char)32;
    private final char B1AsyncPacketParamBit_IO0Edge = '\u0001';
    private final char B1AsyncPacketParamBit_IO1Edge = (char)2;
    private final char B1AsyncPacketParamBit_IO2Edge = (char)4;
    private final char B1AsyncPacketParamBit_IO3Edge = (char)8;
    private final char B1AsyncPacketParamBit_Comparator = (char)16;
    private final char B1AsyncPacketParamBit_RFIDCommand = (char)32;
    private final byte[] AESTestKey = new byte[]{94, 125, 126, 63, 118, 17, 2, 3, 16, 54, 16, 9, 56, 45, 115, 71};
    private final byte[] AESTestVector = new byte[]{117, 83, 95, 46, 30, 109, 46, 15, 64, 99, 11, 13, 58, 114, 55, 116};
    private byte[] testBuff = new byte[16];
    SerialPort serialPort = null;
    boolean terminated = false;
    boolean test_started = false;
    int last_command = 255;
    int last_command_param = 255;
    byte tagType;
    private final byte LED_YELOW_IO = 1;
    private final byte LED_BLUE_IO = (byte)2;
    private final byte BUTTON_IO = (byte)3;
    private final byte BUZZER_IO = 0;
    private final byte LED_ON = (byte)2;
    private final byte LED_OFF = (byte)3;
    static OutputStream serialWriteStream;
    private JButton btnMakeTest;
    private JButton btnOpenClose;
    private JComboBox<String> comboComPort;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTextArea textArea;

    public B1ClientWindow() {
        this.initComponents();
        this.EnumerateComPorts();
        b1 = new B1Module(){

            @Override
            public void Response(B1Module.ResponseArgs args) {
                if (args.Response != 0 && args.Response != 8 && args.Response != 10) {
                    B1ClientWindow.this.PrintTextLine(String.format("Test failed with response 0x%02X", args.Response));
                } else {
                    B1ClientWindow.this.ParseIncommingResponse(args);
                }
            }

            @Override
            public void Request(B1Module.RequestArgs args) {
                B1ClientWindow.writeToSerial(args);
            }
        };
    }

    private void PrintTextLine(String s) {
        this.textArea.append(s + "\n");
    }

    private void SleepMs(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            throw new UnsupportedOperationException("Thread sleep Exception.");
        }
    }

    private void ParseIncommingResponse(B1Module.ResponseArgs args) {
        switch (args.Response) {
            case 0: {
                this.PrintTextLine("<< ACK");
                break;
            }
            case 1: {
                this.PrintTextLine("<< InvalidCommand");
                break;
            }
            case 2: {
                this.PrintTextLine("<< InvalidParameter");
                break;
            }
            case 3: {
                this.PrintTextLine("<< ProtocolError");
                break;
            }
            case 4: {
                this.PrintTextLine("<< MemoryError");
                break;
            }
            case 5: {
                this.PrintTextLine("<< SystemError");
                break;
            }
            case 6: {
                this.PrintTextLine("<< ModuleTimeout");
                break;
            }
            case 7: {
                this.PrintTextLine("<< Overflow");
                break;
            }
            case 8: {
                this.PrintTextLine("<< AsynchronousPacket");
                break;
            }
            case 9: {
                this.PrintTextLine("<< Busy");
                break;
            }
            case 10: {
                this.PrintTextLine("<< SystemStart");
                break;
            }
            default: {
                this.PrintTextLine(String.format("<< Unknown frame type (0x%02X)", args.Response));
            }
        }
        if (args.Parameters != null && args.Parameters.length > 0) {
            int k = 0;
            this.textArea.append("<< ");
            for (byte b : args.Parameters) {
                this.textArea.append(String.format("0x%02X ", b));
                if (++k % 12 != 0) continue;
                this.textArea.append("\n<< ");
            }
            this.textArea.append("\n");
        }
        if (args.Response == 0) {
            block13 : switch (this.last_command) {
                case 0: {
                    this.PrintTextLine(">> SetIOState(Button - input)");
                    this.last_command = 8;
                    this.last_command_param = 3;
                    b1.SendSetIoStateCommand((byte)3, (byte)1);
                    break;
                }
                case 8: {
                    int value;
                    switch (this.last_command_param) {
                        case 3: {
                            this.PrintTextLine(">> SetIOInterrupt(Button)");
                            this.last_command = 10;
                            this.last_command_param = 3;
                            b1.SendSetIoInterruptCommand((byte)3, (byte)0);
                            break block13;
                        }
                        case 2: {
                            this.PrintTextLine(">> SetIOState(IO2)");
                            this.last_command = 8;
                            this.last_command_param = 1;
                            if (this.tagType == 0) {
                                b1.SendSetIoStateCommand((byte)1, (byte)2);
                                break block13;
                            }
                            b1.SendSetIoStateCommand((byte)1, (byte)3);
                            break block13;
                        }
                        case 1: {
                            value = 2400;
                            this.PrintTextLine(">> EnablePWM(BUZZER_IO)");
                            this.last_command = 16;
                            if (this.tagType == 0) {
                                value = 1200;
                            }
                            this.last_command_param = value;
                            b1.SendEnablePwmCommand((byte)0, value, (byte)0, (byte)50);
                            break block13;
                        }
                    }
                    this.PrintTextLine(">> SetIOState ACK - unknown state");
                    break;
                }
                case 16: {
                    if (this.last_command_param != 0) {
                        this.PrintTextLine(">> SetHeaderType(TypeB)");
                        b1.SendSetHeaderTypeCommand((byte)1);
                        this.last_command = 7;
                        this.last_command_param = 1;
                        break;
                    }
                    this.PrintTextLine("Test finished - press the button to repeat the test");
                    this.test_started = false;
                    break;
                }
                case 10: {
                    this.PrintTextLine(">> SetBaudRate(115200)");
                    this.last_command = 5;
                    this.last_command_param = 115200;
                    b1.SendSetBaudRateCommand(115200);
                    break;
                }
                case 7: {
                    b1.getClass();
                    this.SleepMs(50);
                    b1.SetPacketHeaderType((byte)this.last_command_param);
                    if (this.last_command_param == 1) {
                        this.PrintTextLine(">> MeasureDieTemperature");
                        b1.SendMeasureDieTemperatureVoltage((byte)2);
                        this.last_command = 12;
                        break;
                    }
                    int value = 0;
                    this.PrintTextLine(">> BUZZER off");
                    this.last_command = 16;
                    this.last_command_param = value;
                    b1.SendSetIoStateCommand((byte)0, (byte)3);
                    break;
                }
                case 5: {
                    this.serialPort.setBaudRate(this.last_command_param);
                    b1.getClass();
                    this.SleepMs(50);
                    if (this.last_command_param == 115200) {
                        this.PrintTextLine(">> SetAESKey()");
                        b1.SendSetAesKeyCommand(this.AESTestKey);
                        this.last_command = 18;
                        break;
                    }
                    this.PrintTextLine(">> SetHeaderType(TypeA)");
                    b1.SendSetHeaderTypeCommand((byte)0);
                    this.last_command = 7;
                    this.last_command_param = 0;
                    break;
                }
                case 18: {
                    b1.getClass();
                    this.SleepMs(50);
                    this.PrintTextLine(">> SetAESInitVector()");
                    b1.SendSetAesInitVectorCommand(this.AESTestVector);
                    this.last_command = 17;
                    break;
                }
                case 17: {
                    b1.getClass();
                    this.SleepMs(50);
                    this.PrintTextLine(">> SetPacketEncoding(Encrypted)");
                    b1.SendSetDataTypeCommand((byte)1);
                    this.last_command = 6;
                    this.last_command_param = 1;
                    break;
                }
                case 6: {
                    b1.getClass();
                    this.SleepMs(50);
                    b1.SetPacketEncoding((byte)this.last_command_param, this.AESTestKey, this.AESTestVector);
                    if (this.last_command_param == 1) {
                        byte[] buff = new byte[]{1};
                        this.PrintTextLine(">> WriteToRfidMemory(GetUIDAndType)");
                        b1.SendWriteToRfidMemoryCommand(1, buff);
                        this.last_command = 1;
                        this.last_command_param = 1;
                        break;
                    }
                    this.PrintTextLine(">> SetBaudRate(B1SerialBaudrate_Default)");
                    this.last_command = 5;
                    this.last_command_param = 9600;
                    b1.SendSetBaudRateCommand(9600);
                    break;
                }
                case 1: {
                    if (this.last_command_param != 32) break;
                    this.PrintTextLine(">> ReadFromRfidMemory(DataBuffer)");
                    b1.SendReadFromRfidMemoryCommand(32, this.testBuff.length);
                    this.last_command = 2;
                    this.last_command_param = 32;
                    break;
                }
                case 12: {
                    float temp = ByteBuffer.wrap(args.Parameters).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                    this.PrintTextLine(String.format("   Info: Temperature is %.2fC", Float.valueOf(temp)));
                    this.PrintTextLine(">> WriteToRfidMemory(DataBuff)");
                    Random r = new Random();
                    r.nextBytes(this.testBuff);
                    b1.SendWriteToRfidMemoryCommand(32, this.testBuff);
                    this.last_command = 1;
                    this.last_command_param = 32;
                    break;
                }
                case 2: {
                    switch (this.last_command_param) {
                        case 20: {
                            switch (args.Parameters[10]) {
                                case 0: {
                                    this.PrintTextLine("<= TagType: NoTag");
                                    break;
                                }
                                case 1: {
                                    this.PrintTextLine("<= TagType: NotComplete");
                                    break;
                                }
                                case 2: {
                                    this.PrintTextLine("<= TagType: Ultralight");
                                    break;
                                }
                                case 3: {
                                    this.PrintTextLine("<= TagType: UltralightEV1_80B");
                                    break;
                                }
                                case 4: {
                                    this.PrintTextLine("<= TagType: UltralightEV1_164B");
                                    break;
                                }
                                case 5: {
                                    this.PrintTextLine("<= TagType: ClassicMini");
                                    break;
                                }
                                case 6: {
                                    this.PrintTextLine("<= TagType: Classic1K");
                                    break;
                                }
                                case 7: {
                                    this.PrintTextLine("<= TagType: Classic4K");
                                    break;
                                }
                                case 8: {
                                    this.PrintTextLine("<= TagType: NTAG203F");
                                    break;
                                }
                                case 9: {
                                    this.PrintTextLine("<= TagType: NTAG210");
                                    break;
                                }
                                case 10: {
                                    this.PrintTextLine("<= TagType: NTAG212");
                                    break;
                                }
                                case 11: {
                                    this.PrintTextLine("<= TagType: NTAG213F");
                                    break;
                                }
                                case 12: {
                                    this.PrintTextLine("<= TagType: NTAG216F");
                                    break;
                                }
                                case 13: {
                                    this.PrintTextLine("<= TagType: NTAG213");
                                    break;
                                }
                                case 14: {
                                    this.PrintTextLine("<= TagType: NTAG215");
                                    break;
                                }
                                case 15: {
                                    this.PrintTextLine("<= TagType: NTAG216");
                                    break;
                                }
                                default: {
                                    this.PrintTextLine("<= TagType: Unknown");
                                }
                            }
                            this.tagType = args.Parameters[10];
                            if (args.Parameters[11] > 0 && this.tagType != 0) {
                                this.PrintTextLine(String.format("<< Tag UID size: %d", args.Parameters[11]));
                                this.PrintTextLine("<< UID: ");
                                for (int i = 0; i < args.Parameters[11]; ++i) {
                                    this.textArea.append(String.format("0x%02X ", args.Parameters[i]));
                                }
                                this.PrintTextLine("");
                            }
                            this.PrintTextLine(">> WriteToRfidMemory(Halt)");
                            byte[] buff = new byte[]{24};
                            b1.SendWriteToRfidMemoryCommand(1, buff);
                            this.last_command = 1;
                            this.last_command_param = 24;
                            break block13;
                        }
                        case 32: {
                            if (Arrays.equals(args.Parameters, this.testBuff)) {
                                this.PrintTextLine("   Info: Read/Write test passed");
                            } else {
                                this.PrintTextLine("   Info: Read/Write test FAIL!!!");
                            }
                            this.PrintTextLine(">> EnterSleepMode()");
                            b1.SendEnterSleepModeCommand();
                            this.last_command = 3;
                            break block13;
                        }
                    }
                    this.PrintTextLine(String.format("Response on ReadFromRfidMemory in unknown state 0x%02X", this.last_command_param));
                    break;
                }
                case 3: {
                    this.SleepMs(100);
                    this.PrintTextLine(">> WakeUpModule");
                    b1.SendWakeUpByte();
                    this.last_command = 255;
                    break;
                }
                case 255: {
                    this.PrintTextLine(">> WakeUpModule - OK");
                    this.PrintTextLine(">> SetPacketEncoding(Plain)");
                    b1.SendSetDataTypeCommand((byte)0);
                    this.last_command = 6;
                    this.last_command_param = 0;
                    break;
                }
                default: {
                    this.PrintTextLine(String.format("ACK on command: 0x%02X", this.last_command));
                }
            }
        }
        if (args.Response == 8) {
            if ((args.Parameters[0] & 8) > 0) {
                this.textArea.setText("");
                this.PrintTextLine(">>> Button pressed!");
                if (!this.test_started) {
                    this.PrintTextLine(">> SendDummyCommand");
                    b1.SendDummyCommand();
                    this.last_command = 0;
                    this.test_started = true;
                }
            } else {
                block56 : switch (this.last_command) {
                    case 1: {
                        if ((args.Parameters[0] & 0x20) <= 0) break;
                        switch (this.last_command_param) {
                            case 1: {
                                this.PrintTextLine(">> ReadFromRFIDMemory(TagUID)");
                                b1.SendReadFromRfidMemoryCommand(20, 12);
                                this.last_command = 2;
                                this.last_command_param = 20;
                                break block56;
                            }
                            case 24: {
                                this.PrintTextLine(">> SetIOState(LED_BLUE_IO)");
                                this.last_command = 8;
                                this.last_command_param = 2;
                                if (this.tagType == 0) {
                                    b1.SendSetIoStateCommand((byte)2, (byte)3);
                                    break block56;
                                }
                                b1.SendSetIoStateCommand((byte)2, (byte)2);
                            }
                        }
                    }
                }
            }
        }
        if (args.Response == 10) {
            this.PrintTextLine("<< SystemStart received - something to do ?");
        }
    }

    private void initComponents() {
        this.btnMakeTest = new JButton();
        this.comboComPort = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane2 = new JScrollPane();
        this.textArea = new JTextArea();
        this.btnOpenClose = new JButton();
        this.setDefaultCloseOperation(3);
        this.btnMakeTest.setText("Make test");
        this.btnMakeTest.setEnabled(false);
        this.btnMakeTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                B1ClientWindow.this.btnMakeTestActionPerformed(evt);
            }
        });
        this.comboComPort.setName("comboComPort");
        this.jLabel1.setText("Please select serial port:");
        this.textArea.setEditable(false);
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.jScrollPane2.setViewportView(this.textArea);
        this.btnOpenClose.setText("Open");
        this.btnOpenClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                B1ClientWindow.this.btnOpenCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboComPort, -2, 223, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnOpenClose, -1, 74, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMakeTest, -2, 98, -2)).addComponent(this.jSeparator1).addComponent(this.jScrollPane2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnMakeTest).addComponent(this.comboComPort, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.btnOpenClose)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 492, Short.MAX_VALUE).addContainerGap()));
        this.btnMakeTest.getAccessibleContext().setAccessibleName("btnMakeTest");
        this.comboComPort.getAccessibleContext().setAccessibleName("comboComPort");
        this.getAccessibleContext().setAccessibleName("B1ClientExample");
        this.getAccessibleContext().setAccessibleDescription("B1ClientExample");
        this.pack();
    }

    private void btnMakeTestActionPerformed(ActionEvent evt) {
        this.textArea.setText("");
        this.PrintTextLine("Start test:");
        this.PrintTextLine(">> SendDummyCommand");
        b1.SendDummyCommand();
        this.last_command = 0;
    }

    private void btnOpenCloseActionPerformed(ActionEvent evt) {
        if (this.serialPort == null || !this.serialPort.isOpen()) {
            if (this.OpenSerialPort(9600)) {
                this.btnOpenClose.setText("Close");
                this.btnMakeTest.setEnabled(true);
            }
        } else {
            this.CloseSerialPort();
            this.btnOpenClose.setText("Open");
            this.btnMakeTest.setEnabled(false);
        }
    }

    private boolean OpenSerialPort(int baudRate) {
        if (this.serialPort != null && this.serialPort.isOpen()) {
            this.serialPort.closePort();
        }
        this.serialPort = SerialPort.getCommPort(String.valueOf(this.comboComPort.getSelectedItem()));
        if (this.serialPort == null) {
            JOptionPane.showMessageDialog(this, "Error!", "Can't find selected port!", 0);
            return false;
        }
        this.serialPort.setBaudRate(baudRate);
        this.serialPort.setFlowControl(0);
        this.serialPort.setNumStopBits(1);
        this.serialPort.setParity(0);
        if (!this.serialPort.openPort()) {
            JOptionPane.showMessageDialog(this, "Error!", "Can't open serial port!", 0);
            this.serialPort = null;
            return false;
        }
        this.serialPort.addDataListener(new SerialPortDataListener(){

            @Override
            public int getListeningEvents() {
                return 1;
            }

            @Override
            public void serialEvent(SerialPortEvent event) {
                if (event.getEventType() != 1) {
                    return;
                }
                byte[] newData = new byte[B1ClientWindow.this.serialPort.bytesAvailable()];
                int numRead = B1ClientWindow.this.serialPort.readBytes(newData, newData.length);
                b1.SupplyRxData(newData);
            }
        });
        serialWriteStream = this.serialPort.getOutputStream();
        return true;
    }

    private void CloseSerialPort() {
        this.serialPort.closePort();
        this.serialPort = null;
        serialWriteStream = null;
    }

    private static void writeToSerial(B1Module.RequestArgs args) {
        if (serialWriteStream == null) {
            throw new UnsupportedOperationException("Output stream not initialised!");
        }
        try {
            serialWriteStream.write(args.Data);
            serialWriteStream.flush();
        }
        catch (IOException ex) {
            throw new UnsupportedOperationException("Can't write to serial");
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(B1ClientWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new B1ClientWindow().setVisible(true);
            }
        });
    }

    private void EnumerateComPorts() {
        SerialPort[] ports = SerialPort.getCommPorts();
        this.comboComPort.removeAllItems();
        for (SerialPort port : ports) {
            this.comboComPort.addItem(port.getSystemPortName());
        }
    }

    static {
        serialWriteStream = null;
    }
}

