/*
 * Decompiled with CFR 0.152.
 */
package b1module;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.Timer;

public class B1Module {
    private final char[] CCITTCRCTable = new char[]{'\u0000', '\u1021', '\u2042', '\u3063', '\u4084', '\u50a5', '\u60c6', '\u70e7', '\u8108', '\u9129', '\ua14a', '\ub16b', '\uc18c', '\ud1ad', '\ue1ce', '\uf1ef', '\u1231', '\u0210', '\u3273', '\u2252', '\u52b5', '\u4294', '\u72f7', '\u62d6', '\u9339', '\u8318', '\ub37b', '\ua35a', '\ud3bd', '\uc39c', '\uf3ff', '\ue3de', '\u2462', '\u3443', '\u0420', '\u1401', '\u64e6', '\u74c7', '\u44a4', '\u5485', '\ua56a', '\ub54b', '\u8528', '\u9509', '\ue5ee', '\uf5cf', '\uc5ac', '\ud58d', '\u3653', '\u2672', '\u1611', '\u0630', '\u76d7', '\u66f6', '\u5695', '\u46b4', '\ub75b', '\ua77a', '\u9719', '\u8738', '\uf7df', '\ue7fe', '\ud79d', '\uc7bc', '\u48c4', '\u58e5', '\u6886', '\u78a7', '\u0840', '\u1861', '\u2802', '\u3823', '\uc9cc', '\ud9ed', '\ue98e', '\uf9af', '\u8948', '\u9969', '\ua90a', '\ub92b', '\u5af5', '\u4ad4', '\u7ab7', '\u6a96', '\u1a71', '\u0a50', '\u3a33', '\u2a12', '\udbfd', '\ucbdc', '\ufbbf', '\ueb9e', '\u9b79', '\u8b58', '\ubb3b', '\uab1a', '\u6ca6', '\u7c87', '\u4ce4', '\u5cc5', '\u2c22', '\u3c03', '\u0c60', '\u1c41', '\uedae', '\ufd8f', '\ucdec', '\uddcd', '\uad2a', '\ubd0b', '\u8d68', '\u9d49', '\u7e97', '\u6eb6', '\u5ed5', '\u4ef4', '\u3e13', '\u2e32', '\u1e51', '\u0e70', '\uff9f', '\uefbe', '\udfdd', '\ucffc', '\ubf1b', '\uaf3a', '\u9f59', '\u8f78', '\u9188', '\u81a9', '\ub1ca', '\ua1eb', '\ud10c', '\uc12d', '\uf14e', '\ue16f', '\u1080', '\u00a1', '\u30c2', '\u20e3', '\u5004', '\u4025', '\u7046', '\u6067', '\u83b9', '\u9398', '\ua3fb', '\ub3da', '\uc33d', '\ud31c', '\ue37f', '\uf35e', '\u02b1', '\u1290', '\u22f3', '\u32d2', '\u4235', '\u5214', '\u6277', '\u7256', '\ub5ea', '\ua5cb', '\u95a8', '\u8589', '\uf56e', '\ue54f', '\ud52c', '\uc50d', '\u34e2', '\u24c3', '\u14a0', '\u0481', '\u7466', '\u6447', '\u5424', '\u4405', '\ua7db', '\ub7fa', '\u8799', '\u97b8', '\ue75f', '\uf77e', '\uc71d', '\ud73c', '\u26d3', '\u36f2', '\u0691', '\u16b0', '\u6657', '\u7676', '\u4615', '\u5634', '\ud94c', '\uc96d', '\uf90e', '\ue92f', '\u99c8', '\u89e9', '\ub98a', '\ua9ab', '\u5844', '\u4865', '\u7806', '\u6827', '\u18c0', '\u08e1', '\u3882', '\u28a3', '\ucb7d', '\udb5c', '\ueb3f', '\ufb1e', '\u8bf9', '\u9bd8', '\uabbb', '\ubb9a', '\u4a75', '\u5a54', '\u6a37', '\u7a16', '\u0af1', '\u1ad0', '\u2ab3', '\u3a92', '\ufd2e', '\ued0f', '\udd6c', '\ucd4d', '\ubdaa', '\uad8b', '\u9de8', '\u8dc9', '\u7c26', '\u6c07', '\u5c64', '\u4c45', '\u3ca2', '\u2c83', '\u1ce0', '\u0cc1', '\uef1f', '\uff3e', '\ucf5d', '\udf7c', '\uaf9b', '\ubfba', '\u8fd9', '\u9ff8', '\u6e17', '\u7e36', '\u4e55', '\u5e74', '\u2e93', '\u3eb2', '\u0ed1', '\u1ef0'};
    private boolean Receiving = false;
    private final byte STX = (byte)2;
    private final byte ETX = (byte)3;
    private final byte DLE = (byte)16;
    private int ByteCounter;
    private char RxDataSize;
    private byte[] RxBuffer = new byte[65536];
    private byte DataType = 0;
    private byte HeaderType = 0;
    private byte NewHeaderType = 0;
    private byte[] AesKey = new byte[16];
    private byte[] AesIv = new byte[16];
    private boolean DLEReceived = false;
    private Timer TimeOutTimer;
    private final int TimeOutValue_ms = 100;
    private ResponseArgs ProcessedPacket;
    public final int TimeoutMs_Startup = 100;
    public final int TimeoutMs_Interrupt = 50;
    public final int TimeoutMs_Comparator = 50;
    public final int TimeoutMs_CommunicationParameterChange = 50;

    public B1Module() {
        this.AesKey = new byte[16];
        this.AesIv = new byte[16];
        for (int i = 0; i < 16; ++i) {
            this.AesKey[i] = 0;
            this.AesIv[i] = 0;
        }
        ActionListener TimeOutListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("timeout!!!");
                B1Module.this.Receiving = false;
            }
        };
        this.TimeOutTimer = new Timer(100, TimeOutListener);
        this.TimeOutTimer.setRepeats(false);
        this.TimeOutTimer.setInitialDelay(100);
    }

    public void Response(ResponseArgs args) {
        throw new UnsupportedOperationException("Response not defined!");
    }

    public void Request(RequestArgs args) {
        throw new UnsupportedOperationException("Request not defined!");
    }

    private void GenerateInvalidPacketEvent() {
        this.Response(new ResponseArgs(-2, null, '\u0000', '\u0000'));
    }

    private void GenerateClientTimeoutEvent() {
        this.Response(new ResponseArgs(-1, null, '\u0000', '\u0000'));
    }

    private boolean ResponseIsDefined(int type) {
        return type <= 10 || type >= 254;
    }

    private void ProcessPacketData(byte[] PacketData) {
        if (this.DataType == 0) {
            this.ProcessedPacket.DataCRC = (char)(PacketData[PacketData.length - 1] << 8 | PacketData[PacketData.length - 2] & 0xFF);
            if (this.ProcessedPacket.DataCRC != this.GetCRC(PacketData, 0, PacketData.length - 2)) {
                this.GenerateInvalidPacketEvent();
                return;
            }
            if (!this.ResponseIsDefined(PacketData[0] & 0xFF)) {
                this.GenerateInvalidPacketEvent();
                return;
            }
            this.ProcessedPacket.Response = PacketData[0];
            if (PacketData.length > 3) {
                this.ProcessedPacket.Parameters = new byte[PacketData.length - 3];
                System.arraycopy(PacketData, 1, this.ProcessedPacket.Parameters, 0, this.ProcessedPacket.Parameters.length);
            } else {
                this.ProcessedPacket.Parameters = null;
            }
            this.Response(this.ProcessedPacket);
        } else if (this.DataType == 1) {
            if (PacketData.length % 16 != 0) {
                this.GenerateInvalidPacketEvent();
                return;
            }
            byte[] PlainData = this.Decrypt(PacketData);
            char LastValidIndex = (char)(PlainData[1] << 8 | PlainData[0] & 0xFF);
            if (LastValidIndex < '\u0005') {
                this.GenerateInvalidPacketEvent();
                return;
            }
            this.ProcessedPacket.DataCRC = (char)(PlainData[LastValidIndex - '\u0001'] << 8 | PlainData[LastValidIndex - 2] & 0xFF);
            if (this.ProcessedPacket.DataCRC != this.GetCRC(PlainData, 0, LastValidIndex - 2)) {
                this.GenerateInvalidPacketEvent();
                return;
            }
            if (!this.ResponseIsDefined(PlainData[2])) {
                this.GenerateInvalidPacketEvent();
                return;
            }
            this.ProcessedPacket.Response = PlainData[2];
            if (LastValidIndex > '\u0005') {
                this.ProcessedPacket.Parameters = new byte[LastValidIndex - 5];
                System.arraycopy(PlainData, 3, this.ProcessedPacket.Parameters, 0, this.ProcessedPacket.Parameters.length);
            } else {
                this.ProcessedPacket.Parameters = null;
            }
            this.Response(this.ProcessedPacket);
        }
    }

    public void SupplyRxData(byte[] Data) {
        if (Data.length == 0) {
            throw new UnsupportedOperationException("Data is null");
        }
        block9: for (byte DataByte : Data) {
            switch (this.HeaderType) {
                case 0: {
                    if (!this.Receiving) {
                        if (DataByte == 2) {
                            this.TimeOutTimer.restart();
                            this.ProcessedPacket = new ResponseArgs();
                            this.RxBuffer[0] = 2;
                            this.Receiving = true;
                            this.ByteCounter = 1;
                            this.RxDataSize = '\u0000';
                            continue block9;
                        }
                        this.TimeOutTimer.stop();
                        continue block9;
                    }
                    this.TimeOutTimer.restart();
                    this.RxBuffer[this.ByteCounter++] = DataByte;
                    if (this.ByteCounter == 5) {
                        this.ProcessedPacket.HeaderCRC = (char)(this.RxBuffer[4] << 8 | this.RxBuffer[3] & 0xFF);
                        if (this.ProcessedPacket.HeaderCRC != this.GetCRC(this.RxBuffer, 0, 3)) {
                            this.GenerateInvalidPacketEvent();
                            this.Receiving = false;
                            this.HeaderType = this.NewHeaderType;
                            return;
                        }
                        this.RxDataSize = (char)(this.RxBuffer[2] << 8 | this.RxBuffer[1] & 0xFF);
                        if (this.RxDataSize >= '\u0003') continue block9;
                        this.TimeOutTimer.stop();
                        this.GenerateInvalidPacketEvent();
                        this.Receiving = false;
                        this.HeaderType = this.NewHeaderType;
                        continue block9;
                    }
                    if (this.ByteCounter == this.RxBuffer.length) {
                        this.TimeOutTimer.stop();
                        this.GenerateInvalidPacketEvent();
                        this.Receiving = false;
                        this.HeaderType = this.NewHeaderType;
                        continue block9;
                    }
                    if (this.ByteCounter != 5 + this.RxDataSize) continue block9;
                    this.TimeOutTimer.stop();
                    this.Receiving = false;
                    this.HeaderType = this.NewHeaderType;
                    byte[] PacketData = new byte[this.RxDataSize];
                    System.arraycopy(this.RxBuffer, 5, PacketData, 0, PacketData.length);
                    this.ProcessPacketData(PacketData);
                    continue block9;
                }
                case 1: {
                    byte[] PacketData;
                    if (!this.Receiving) {
                        if (DataByte == 2) {
                            this.TimeOutTimer.restart();
                            this.RxBuffer[0] = 2;
                            this.ProcessedPacket = new ResponseArgs();
                            this.Receiving = true;
                            this.ByteCounter = 1;
                            this.DLEReceived = false;
                            continue block9;
                        }
                        this.TimeOutTimer.stop();
                        continue block9;
                    }
                    if (this.ByteCounter == this.RxBuffer.length) {
                        this.TimeOutTimer.stop();
                        this.GenerateInvalidPacketEvent();
                        this.Receiving = false;
                        this.HeaderType = this.NewHeaderType;
                        continue block9;
                    }
                    switch (DataByte) {
                        case 2: {
                            this.TimeOutTimer.stop();
                            this.GenerateInvalidPacketEvent();
                            this.Receiving = false;
                            this.HeaderType = this.NewHeaderType;
                            continue block9;
                        }
                        case 3: {
                            this.TimeOutTimer.stop();
                            if (this.DLEReceived || this.ByteCounter < 2) {
                                this.GenerateInvalidPacketEvent();
                                continue block9;
                            }
                            this.ProcessedPacket.HeaderCRC = '\u0000';
                            this.Receiving = false;
                            PacketData = new byte[this.ByteCounter - 1];
                            System.arraycopy(this.RxBuffer, 1, PacketData, 0, PacketData.length);
                            this.ProcessPacketData(PacketData);
                            continue block9;
                        }
                        case 16: {
                            this.TimeOutTimer.restart();
                            this.DLEReceived = true;
                            continue block9;
                        }
                    }
                    this.TimeOutTimer.restart();
                    if (this.DLEReceived) {
                        this.DLEReceived = false;
                        this.RxBuffer[this.ByteCounter++] = (byte)(DataByte - 16);
                        continue block9;
                    }
                    this.RxBuffer[this.ByteCounter++] = DataByte;
                }
            }
        }
    }

    public byte[] FlushRxBuffer() {
        if (this.ByteCounter == 0) {
            return null;
        }
        byte[] Data = new byte[this.ByteCounter];
        System.arraycopy(this.RxBuffer, 0, Data, 0, Data.length);
        return Data;
    }

    private void Crc(byte[] Data, int Index, int Count) {
        if (Index + Count + 2 > Data.length) {
            throw new UnsupportedOperationException("[Crc]: Not enough space to store crc.");
        }
        if (Count == 0) {
            throw new UnsupportedOperationException("[Crc]: Parameter Count has to be larger than 0.");
        }
        int CRC = 65535;
        for (int i = 0; i < Count; ++i) {
            char Temp = (char)((CRC >> 8 ^ (char)Data[Index + i]) & 0xFF);
            CRC = (char)(this.CCITTCRCTable[Temp] ^ (char)(CRC << 8 & 0xFFFF));
        }
        Data[Index + Count] = (byte)(CRC & 0xFF);
        Data[Index + Count + 1] = (byte)(CRC >> 8 & 0xFF);
    }

    private char GetCRC(byte[] Data, int Index, int Count) {
        if (Index + Count > Data.length || Count == 0) {
            throw new UnsupportedOperationException("[GetCRC]: Invalid input parameters.");
        }
        char CRC = '\uffff';
        for (int i = 0; i < Count; ++i) {
            char Temp = (char)((CRC >> 8 ^ (char)Data[Index + i]) & 0xFF);
            CRC = (char)(this.CCITTCRCTable[Temp] ^ (char)(CRC << 8 & 0xFFFF));
        }
        return CRC;
    }

    private boolean IsSpecialChar(byte c) {
        return c == 2 || c == 3 || c == 16;
    }

    private void SendPacketA(byte[] Data) {
        byte[] Packet = new byte[Data.length + 5];
        Packet[0] = 2;
        Packet[1] = (byte)(Data.length & 0xFF);
        Packet[2] = (byte)(Data.length >> 8 & 0xFF);
        this.Crc(Packet, 0, 3);
        System.arraycopy(Data, 0, Packet, 5, Data.length);
        this.Request(new RequestArgs(Packet));
    }

    private void SendPacketB(byte[] Data) {
        int PacketSize = 2 + Data.length;
        for (int i = 0; i < Data.length; ++i) {
            if (!this.IsSpecialChar(Data[i])) continue;
            ++PacketSize;
        }
        byte[] Packet = new byte[PacketSize];
        Packet[0] = 2;
        Packet[PacketSize - 1] = 3;
        int index = 1;
        for (int i = 0; i < Data.length; ++i) {
            if (this.IsSpecialChar(Data[i])) {
                Packet[index++] = 16;
                Packet[index++] = (byte)(Data[i] + 16);
                continue;
            }
            Packet[index++] = Data[i];
        }
        this.Request(new RequestArgs(Packet));
    }

    private byte[] Encrypt(byte[] Data) {
        try {
            IvParameterSpec iv = new IvParameterSpec(this.AesIv);
            SecretKeySpec skeySpec = new SecretKeySpec(this.AesKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NOPADDING");
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(Data);
            return encrypted;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private byte[] Decrypt(byte[] PacketData) {
        try {
            IvParameterSpec iv = new IvParameterSpec(this.AesIv);
            SecretKeySpec skeySpec = new SecretKeySpec(this.AesKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NOPADDING");
            cipher.init(2, (Key)skeySpec, iv);
            byte[] original = cipher.doFinal(PacketData);
            return original;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private byte[] PreparePackedData(byte Command, byte[] Data) {
        char DataSize = Data == null || Data.length == 0 ? (char)'\u0001' : (char)(Data.length + 1);
        switch (this.DataType) {
            case 0: {
                byte[] PacketData = new byte[DataSize + 2];
                PacketData[0] = Command;
                if (DataSize > '\u0001') {
                    System.arraycopy(Data, 0, PacketData, 1, DataSize - '\u0001');
                }
                this.Crc(PacketData, 0, DataSize);
                return PacketData;
            }
            case 1: {
                char FillSize;
                DataSize = (char)(DataSize + 4);
                if (DataSize % 16 != 0) {
                    char NewSize = (char)(DataSize / 16);
                    NewSize = (char)(NewSize + '\u0001');
                    NewSize = (char)(NewSize * 16);
                    FillSize = (char)(NewSize - DataSize);
                } else {
                    FillSize = '\u0000';
                }
                byte[] PlainData = new byte[DataSize + FillSize];
                PlainData[0] = (byte)(DataSize & 0xFF);
                PlainData[1] = (byte)(DataSize >> 8 & 0xFF);
                PlainData[2] = Command;
                if (DataSize > '\u0005') {
                    System.arraycopy(Data, 0, PlainData, 3, DataSize - 5);
                }
                this.Crc(PlainData, 0, DataSize - 2);
                if (FillSize > '\u0000') {
                    Random r = new Random();
                    byte[] randomData = new byte[FillSize];
                    r.nextBytes(randomData);
                    System.arraycopy(randomData, 0, PlainData, DataSize, FillSize);
                }
                byte[] EncryptedData = this.Encrypt(PlainData);
                return EncryptedData;
            }
        }
        return null;
    }

    private void SendCommand(byte Command, byte[] Data) {
        byte[] PacketData = this.PreparePackedData(Command, Data);
        switch (this.HeaderType) {
            case 0: {
                this.SendPacketA(PacketData);
                break;
            }
            case 1: {
                this.SendPacketB(PacketData);
            }
        }
    }

    public void SendDummyCommand() {
        this.SendCommand((byte)0, null);
    }

    public void SendWriteToRfidMemoryCommand(int Address, byte[] Data) {
        if (Data.length == 0) {
            throw new UnsupportedOperationException("[SendWriteToRFIDMemoryCommand]: Data length is equal to 0.");
        }
        byte[] Parameters = new byte[Data.length + 4];
        Parameters[0] = (byte)(Address & 0xFF);
        Parameters[1] = (byte)(Address >> 8 & 0xFF);
        Parameters[2] = (byte)(Data.length & 0xFF);
        Parameters[3] = (byte)(Data.length >> 8 & 0xFF);
        System.arraycopy(Data, 0, Parameters, 4, Data.length);
        this.SendCommand((byte)1, Parameters);
    }

    public void SendReadFromRfidMemoryCommand(int Address, int DataSize) {
        byte[] Data = new byte[]{(byte)(Address & 0xFF), (byte)(Address >> 8 & 0xFF), (byte)(DataSize & 0xFF), (byte)(DataSize >> 8 & 0xFF)};
        this.SendCommand((byte)2, Data);
    }

    public void SendEnterSleepModeCommand() {
        this.SendCommand((byte)3, null);
    }

    public void SendResetCommand() {
        this.SendCommand((byte)4, null);
    }

    public void SendSetBaudRateCommand(int BaudRate) {
        byte[] Data = new byte[]{(byte)(BaudRate & 0xFF), (byte)((BaudRate & 0xFF00) >> 8), (byte)((BaudRate & 0xFF0000) >> 16), (byte)((BaudRate & 0xFF000000) >> 24)};
        this.SendCommand((byte)5, Data);
    }

    public void SendSetDataTypeCommand(byte newType) {
        byte[] Data = new byte[]{newType};
        this.SendCommand((byte)6, Data);
    }

    public void SendSetHeaderTypeCommand(byte newType) {
        byte[] Data = new byte[]{newType};
        this.SendCommand((byte)7, Data);
    }

    public void SetPacketHeaderType(byte newType) {
        this.NewHeaderType = newType;
        if (!this.Receiving) {
            this.HeaderType = newType;
        }
    }

    public void SetPacketEncoding(byte newDataType, byte[] newAESKey, byte[] newAESInitializationVector) {
        if (newDataType == 1) {
            System.arraycopy(newAESKey, 0, this.AesKey, 0, 16);
            System.arraycopy(newAESInitializationVector, 0, this.AesIv, 0, 16);
        }
        this.DataType = newDataType;
    }

    public void SendSetIoStateCommand(byte Gpio, byte GpioState) {
        byte[] Data = new byte[]{Gpio, GpioState};
        this.SendCommand((byte)8, Data);
    }

    public void SendReadIoStateCommand(byte Gpio) {
        byte[] Data = new byte[]{Gpio};
        this.SendCommand((byte)9, Data);
    }

    public void SendSetIoInterruptCommand(byte Gpio, byte GpioInterrupt) {
        byte[] Data = new byte[]{Gpio, GpioInterrupt};
        this.SendCommand((byte)10, Data);
    }

    public void SendMeasureVoltageCommand(byte AdcSource, byte VoltageFormat) {
        byte[] Data = new byte[]{AdcSource, VoltageFormat};
        this.SendCommand((byte)11, Data);
    }

    public void SendMeasureDieTemperatureVoltage(byte TemperatureFormat) {
        byte[] Data = new byte[]{TemperatureFormat};
        this.SendCommand((byte)12, Data);
    }

    private void SendSetIdacCurrentCommand_nA(int Current) {
        byte[] Data = new byte[5];
        Data[0] = 0;
        System.arraycopy(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(Current).array(), 0, Data, 1, 4);
        this.SendCommand((byte)13, Data);
    }

    private void SendSetIdacCurrentCommand_nA(float Current) {
        byte[] Data = new byte[5];
        Data[0] = 1;
        System.arraycopy(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(Current).array(), 0, Data, 1, 4);
        this.SendCommand((byte)13, Data);
    }

    private void SendSetIdacCurrentCommand_uA(float Current) {
        byte[] Data = new byte[5];
        Data[0] = 2;
        System.arraycopy(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(Current).array(), 0, Data, 1, 4);
        this.SendCommand((byte)13, Data);
    }

    public void SendSetIdacCurrentCommand(byte CurrentFormat, Object Current) {
        switch (CurrentFormat) {
            case 1: {
                this.SendSetIdacCurrentCommand_nA(((Float)Current).floatValue());
                break;
            }
            case 2: {
                this.SendSetIdacCurrentCommand_uA(((Float)Current).floatValue());
                break;
            }
            case 0: {
                this.SendSetIdacCurrentCommand_nA((Integer)Current);
                break;
            }
        }
    }

    public void SendEnableComparatorCommand(byte ReferenceVoltage, byte OutputPin, byte EdgeSensitivity, byte PowerSupplyDivider) {
        if (PowerSupplyDivider > 63) {
            throw new UnsupportedOperationException("[SendEnableComparatorCommand]: PowerSupplyDivider maximum value exceeded.");
        }
        byte[] Data = new byte[]{ReferenceVoltage, OutputPin, EdgeSensitivity, PowerSupplyDivider};
        this.SendCommand((byte)14, Data);
    }

    public void SendDisableComparatorCommand() {
        this.SendCommand((byte)15, null);
    }

    private void SendEnablePwmCommand_Hz(int Frequency, byte Gpio, byte DutyCycle) {
        if (Frequency == 0) {
            throw new UnsupportedOperationException("[SendEnablePwmCommand_Hz]: Frequency parameter is equal to 0.");
        }
        byte[] Data = new byte[7];
        Data[0] = Gpio;
        Data[1] = DutyCycle;
        Data[2] = 0;
        System.arraycopy(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(Frequency).array(), 0, Data, 3, 4);
        this.SendCommand((byte)16, Data);
    }

    private void SendEnablePwmCommand_Hz(float Frequency, byte Gpio, byte DutyCycle) {
        if (Frequency == 0.0f) {
            throw new UnsupportedOperationException("[SendEnablePwmCommand_Hz]: Frequency parameter is equal to 0.");
        }
        byte[] Data = new byte[7];
        Data[0] = Gpio;
        Data[1] = DutyCycle;
        Data[2] = 1;
        System.arraycopy(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(Frequency).array(), 0, Data, 3, 4);
        this.SendCommand((byte)16, Data);
    }

    private void SendEnablePwmCommand_us(int Period, byte Gpio, byte DutyCycle) {
        if (Period == 0) {
            throw new UnsupportedOperationException("[SendEnablePwmCommand_us]: Period parameter is equal to 0.");
        }
        byte[] Data = new byte[7];
        Data[0] = Gpio;
        Data[1] = DutyCycle;
        Data[2] = 2;
        System.arraycopy(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(Period).array(), 0, Data, 3, 4);
        this.SendCommand((byte)16, Data);
    }

    private void SendEnablePwmCommand_s(float Period, byte Gpio, byte DutyCycle) {
        if (Period == 0.0f) {
            throw new UnsupportedOperationException("[SendEnablePwmCommand_s]: Frequency parameter is equal to 0.");
        }
        byte[] Data = new byte[7];
        Data[0] = Gpio;
        Data[1] = DutyCycle;
        Data[2] = 3;
        System.arraycopy(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(Period).array(), 0, Data, 3, 4);
        this.SendCommand((byte)16, Data);
    }

    public void SendEnablePwmCommand(byte PWMConfigFormat, Object Value, byte Gpio, byte DutyCycle) {
        switch (PWMConfigFormat) {
            case 1: {
                this.SendEnablePwmCommand_Hz(((Float)Value).floatValue(), Gpio, DutyCycle);
                break;
            }
            case 3: {
                this.SendEnablePwmCommand_s(((Float)Value).floatValue(), Gpio, DutyCycle);
                break;
            }
            case 0: {
                this.SendEnablePwmCommand_Hz((Integer)Value, Gpio, DutyCycle);
                break;
            }
            case 2: {
                this.SendEnablePwmCommand_us((Integer)Value, Gpio, DutyCycle);
                break;
            }
        }
    }

    public void SendSetAesInitVectorCommand(byte[] InitVector) {
        if (InitVector == null || InitVector.length != 16) {
            throw new UnsupportedOperationException("[SendSetAesInitVectorCommand]: Initialization Vector is not 16 bytes long.");
        }
        this.SendCommand((byte)17, InitVector);
    }

    public void SendSetAesKeyCommand(byte[] AesKey) {
        if (AesKey == null || AesKey.length != 16) {
            throw new UnsupportedOperationException("[SendSetAesKeyCommand]: AES Key is not 16 bytes long.");
        }
        this.SendCommand((byte)18, AesKey);
    }

    public void SendReadAesInitVectorCommand() {
        this.SendCommand((byte)19, null);
    }

    public void SendReadAesKeyCommand() {
        this.SendCommand((byte)20, null);
    }

    public void SendWakeUpByte() {
        byte[] Data = new byte[]{0};
        this.Request(new RequestArgs(Data));
    }

    public void SendStxByte() {
        byte[] Data = new byte[]{2};
        this.Request(new RequestArgs(Data));
    }

    public class ComparatorAsyncPacketEdgeSensitivityT {
        public static final byte Disabled = 0;
        public static final byte FallingEdge = 1;
        public static final byte RisingEdge = 2;
        public static final byte AnyEdge = 3;
    }

    public class ComparatorOutputPinT {
        public static final byte Disabled = 0;
        public static final byte Enabled = 1;
        public static final byte EnabledNegated = 2;
    }

    public class ComparatorReferenceVoltageT {
        public static final byte Ref1V25 = 0;
        public static final byte Ref2V5 = 1;
        public static final byte RefDivVdd = 2;
    }

    public class TemperatureFormatT {
        public static final byte Int32_mC = 0;
        public static final byte Float_mC = 1;
        public static final byte Float_C = 2;
        public static final byte Int32_mF = 3;
        public static final byte Float_mF = 4;
        public static final byte Float_F = 5;
    }

    public class PWMConfigFormatT {
        public static final byte Uint32_Hz = 0;
        public static final byte Float_Hz = 1;
        public static final byte Uint32_us = 2;
        public static final byte Float_s = 3;
    }

    public class CurrentFormatT {
        public static final byte Int32_nA = 0;
        public static final byte Float_nA = 1;
        public static final byte Float_uA = 2;
    }

    public class VoltageFormatT {
        public static final byte Uint32_mv = 0;
        public static final byte Float_mV = 1;
        public static final byte Float_V = 2;
    }

    public class AdcSourceT {
        public static final byte AdcPin = 0;
        public static final byte PowerSupply = 1;
    }

    public class GpioInterruptT {
        public static final byte FallingEdge = 0;
        public static final byte RisingEdge = 1;
        public static final byte AnyEdge = 2;
        public static final byte Disabled = 3;
    }

    public class GpioStateT {
        public static final byte DisabledHiZ = 0;
        public static final byte Input = 1;
        public static final byte OutputLow = 2;
        public static final byte OutputHigh = 3;
    }

    public class GpioT {
        public static final byte Gpio0 = 0;
        public static final byte Gpio1 = 1;
        public static final byte Gpio2 = 2;
        public static final byte Gpio3 = 3;
    }

    public class HeaderTypeT {
        public static final byte A = 0;
        public static final byte B = 1;
    }

    public class DataTypeT {
        public static final byte Plain = 0;
        public static final byte Encrypted = 1;
    }

    public class RequestArgs {
        public byte[] Data;

        public RequestArgs(byte[] Data) {
            this.Data = Data;
        }
    }

    public class ResponseArgs {
        public byte Response;
        public byte[] Parameters;
        public char HeaderCRC;
        public char DataCRC;

        public ResponseArgs(byte Response, byte[] Parameters, char HeaderCRC, char DataCRC) {
            this.Response = Response;
            this.Parameters = Parameters;
            this.HeaderCRC = HeaderCRC;
            this.DataCRC = DataCRC;
        }

        public ResponseArgs() {
            this.Response = 0;
            this.Parameters = null;
            this.HeaderCRC = '\u0000';
            this.DataCRC = '\u0000';
        }
    }

    public class ResponseT {
        public static final byte ACK = 0;
        public static final byte InvalidCommand = 1;
        public static final byte InvalidParameter = 2;
        public static final byte ProtocolError = 3;
        public static final byte MemoryError = 4;
        public static final byte SystemError = 5;
        public static final byte ModuleTimeout = 6;
        public static final byte Overflow = 7;
        public static final byte AsyncPacket = 8;
        public static final byte Busy = 9;
        public static final byte SystemStart = 10;
        public static final byte InvalidPacket = -2;
        public static final byte ClientTimeout = -1;
    }

    public class UartCommandT {
        public static final byte Dummy = 0;
        public static final byte WriteToRfidMemory = 1;
        public static final byte ReadFromRfidMemory = 2;
        public static final byte EnterSleepMode = 3;
        public static final byte Reset = 4;
        public static final byte SetBaudRate = 5;
        public static final byte SetDataType = 6;
        public static final byte SetHeaderType = 7;
        public static final byte SetIoState = 8;
        public static final byte ReadIoState = 9;
        public static final byte SetIoInterrupt = 10;
        public static final byte MeasureVoltage = 11;
        public static final byte MeasureDieTemperature = 12;
        public static final byte SetIdacCurrent = 13;
        public static final byte EnableComparator = 14;
        public static final byte DisableComparator = 15;
        public static final byte EnablePWM = 16;
        public static final byte SetAesInitVector = 17;
        public static final byte SetAesKey = 18;
        public static final byte ReadAesInitVector = 19;
        public static final byte ReadAesKey = 20;
    }

    public class TagType {
        public static final byte NoTag = 0;
        public static final byte NotComplete = 1;
        public static final byte Ultralight = 2;
        public static final byte UltralightEV1_80B = 3;
        public static final byte UltralightEV1_164B = 4;
        public static final byte ClassicMini = 5;
        public static final byte Classic1K = 6;
        public static final byte Classic4K = 7;
        public static final byte NTAG203F = 8;
        public static final byte NTAG210 = 9;
        public static final byte NTAG212 = 10;
        public static final byte NTAG213F = 11;
        public static final byte NTAG216F = 12;
        public static final byte NTAG213 = 13;
        public static final byte NTAG215 = 14;
        public static final byte NTAG216 = 15;
        public static final byte Unknown = 16;
    }
}

