#ifndef __BINARY_PROTOCOL_H__
#define __BINARY_PROTOCOL_H__

#include <QObject>
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>
#include <QTimer>

#define MAX_BINNARY_FRAME_LEN_LEN (2048+20)
#define BINARY_STX	0xF5

class BinaryProtocol : public QObject
{
    Q_OBJECT
public:
    explicit BinaryProtocol(QObject *parent = 0);
    ~BinaryProtocol();

    void send(uint8_t *buff, size_t len);
    void writeRaw(uint8_t *buff, size_t len);
    void repeat(void);
    uint16_t parse(uint8_t *buff, size_t len);
    void setAddress(uint8_t address);
    uint8_t getAddress(void);
private slots:
    void frameTimerTimeout(void);
private:
    uint8_t protocolBuff[MAX_BINNARY_FRAME_LEN_LEN];
    uint16_t protocolBuffIdx;
    uint16_t protocolReqLen=0;

    uint8_t protocolBuffOut[MAX_BINNARY_FRAME_LEN_LEN];
    uint16_t protocolLenOut=0;
    int error_count;
    uint8_t own_address;
    QTimer *frameTimer;
    bool header_detected;
signals:
    void frameComplete(uint8_t *buff, size_t len);
    void frameError();
    void frameTimeout();
    void protocolWrite(uint8_t *buff, size_t len);
};
#endif

