#include "config.h"
#include <QSettings>

Config::Config()
{
    reload();
}

void Config::addCmd(QString name, QString hex)
{
    Command cmd;
    cmd.name = name;
    cmd.hex = hex;
    commands.append(cmd);
}

void Config::save()
{
    QSettings settings("Eccel_Ltd", "C1-client");

    settings.beginWriteArray("commands");
    for (int i = 0; i < commands.size(); ++i) {
        settings.setArrayIndex(i);
        settings.setValue("name", commands.at(i).name);
        settings.setValue("hex", commands.at(i).hex);
    }
    settings.endArray();
}

void Config::deleteCmd(int idx)
{
    commands.removeAt(idx);
}

void Config::reload()
{
    QSettings settings("Eccel_Ltd", "C1-client");

    commands.clear();

    int size = settings.beginReadArray("commands");
    for (int i = 0; i < size; ++i) {
        settings.setArrayIndex(i);
        addCmd(settings.value("name").toString(), settings.value("hex").toString());
    }
    settings.endArray();
}
