#include "newfavcmdwindow.h"
#include "ui_newfavcmdwindow.h"
#include <hexvalidator.h>
#include <QMessageBox>

NewFavCmdWindow::NewFavCmdWindow(QWidget *parent, int idx, QString name, QString hex) :
    QDialog(parent),
    ui(new Ui::NewFavCmdWindow)
{
    ui->setupUi(this);
    ui->leHex->setValidator(new HexValidator(this));
    mIdx = idx;

    ui->leName->setText(name);
    ui->leHex->setText(hex);
}

NewFavCmdWindow::~NewFavCmdWindow()
{
    delete ui;
}

void NewFavCmdWindow::on_buttonBox_accepted()
{
    if (ui->leName->text().isEmpty())
    {
        QMessageBox::information(this, "Waring", "Please enter command name", QMessageBox::Ok);
        ui->leName->setFocus();
        return;
    }

    if (ui->leHex->text().isEmpty())
    {
        QMessageBox::information(this, "Waring", "Please enter bytes to send", QMessageBox::Ok);
        ui->leHex->setFocus();
        return;
    }

    emit addNewFavCommand(this->mIdx , ui->leName->text(), ui->leHex->text());

    this->accept();
}
