#include <Arduino.h>
#include <CCITTCRC.h>
#include <RFIDB1SimpleInterface.h>

#ifdef ESP8266
//pins definition for ESP8266 board like NodeMCU
#include <SoftwareSerial.h>
#define debugSerial Serial
SoftwareSerial b1Serial(13,15);
#define STATUS_LED 16

#elif ESP32
//pins definition for ESP32 board like DOIT DevKit v1
#include <HardwareSerial.h>
HardwareSerial Serial2(2);
#define debugSerial Serial
#define b1Serial Serial2
#define STATUS_LED LED_BUILTIN

#else
//for other platforms
#define debugSerial Serial
#define b1Serial Serial2
#define STATUS_LED LED_BUILTIN
#endif

RFIDB1SimpleInterface *B1Interface;
#define B1SerialBaudrate_Default 9600
#define b1Serial Serial2

uint8_t default_mifare_key[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

void setup() {
  // put your setup code here, to run once:
  b1Serial.begin(B1SerialBaudrate_Default);
  Serial.begin(115200);
  B1Interface = new RFIDB1SimpleInterface(b1Serial);
  Serial.print("Waiting for tag...\n");
}

void loop() {
  uint8_t blockBuff[16]; // must be number of blocks to read * 16
  static uint8_t counter=0;
  if (B1Interface->isTagPresent())
  {
    uint8_t *uid, len;
    Serial.print("Tag [%s]: ", B1Interface->GetUidTypeString());
    len = B1Interface->GetUIDLen();
    uid = B1Interface->GetUIDBytes();
    for (int i=0; i < len; i++)
    {
      Serial.print("0x%02X ", uid[i]);
    }
    Serial.print("\n");

    //read / write test only on Mifare cards
    if ( (B1Interface->GetUIDType() == TagType_Classic1K || B1Interface->GetUIDType() != TagType_Classic4K) &&
          B1Interface->ReadBlock(0, 1, 'A', default_mifare_key, true, blockBuff))
    {
      Serial.print("Data readed: ");
      for (int i=0; i < 16; i++)
      {
        Serial.print("0x%02X ", blockBuff[i]);
      }
      Serial.print("\n");

      memset(blockBuff, counter++, 16);
      if (B1Interface->WriteBlock(0, 1, 'A', default_mifare_key, true, blockBuff))
      {
        Serial.print("New data written: ");
        for (int i=0; i < 16; i++)
        {
          Serial.print("0x%02X ", blockBuff[i]);
        }
        Serial.print("\n");      
      }
      else
        Serial.print("Can't write data!\n");
    }
    else
      Serial.print("Can't read data!\n");

    delay(1000);
  }
  
  B1Interface->Halt();
  delay(100);
}
