/*
  RFIDB1SimpleInterface.h - this file is part of the RFID-B1
  library for RFIDB1 modules by Eccel Technology Ltd.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

   Authors:  Marcin Baliniak, Piotr Szmelcer, Damian Gowor

   Version: 1.0

  See file LICENSE.txt for further informations on licensing terms.
*/

#ifndef RFIDB1SIMPLE_LIBRARY_H_INCLUDED
#define RFIDB1SIMPLE_LIBRARY_H_INCLUDED

#include <Arduino.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include "RFIDB1ClientProtocol.h"
#include "RFIDB1ClientInterface.h"

#ifndef B1_MAX_FRAME_SIZE
#define B1_MAX_FRAME_SIZE 64
#endif

class RFIDB1SimpleInterface {
    public:
        RFIDB1SimpleInterface(Stream &serial);
        bool isTagPresent(void);
        uint8_t GetUIDLen(void);
        uint8_t GetUIDType(void);
        uint8_t *GetUIDBytes(void);
        const char * GetUidTypeString(void);
        bool Halt(void);
        bool ReadBlock(int blockNum, int blocks2read, char keyAB, uint8_t *key, bool dataOnly, uint8_t *outBuff);
        bool WriteBlock(int blockNum, int blocks2write, char keyAB, uint8_t *key, bool dataOnly, uint8_t *buff2write);
    private:
        uint8_t uidBytes[20];
        uint8_t uidLen;
        uint8_t uidType;
        RFIDB1_Interface *B1ClientInterface;

        uint8_t rxBuff[B1_MAX_FRAME_SIZE * 2];
        uint8_t txBuff[B1_MAX_FRAME_SIZE * 2];

        bool wait4Answer(bool needAck, bool needAsync, uint16_t timeout);
        bool ReadFromRfidMemory(uint16_t address, uint16_t len);
        bool WriteToRfidMemory(uint16_t address, uint8_t *buff, uint16_t len);
        const char* GetResultString(uint8_t status);
};

#endif // RFIDB1SIMPLE_LIBRARY_H_INCLUDED
